#include <windows.h>
#include "smint.h"


#ifdef TEST

  HANDLE  LogH = NULL;
  int     DbgUsage = 0;

  static BOOL DbgCreateOutput()
    {
      char  *cp;

      if( 0 != DbgUsage++ ) return TRUE;

      // create log file

      if( GetModuleFileName( NULL, DbgMsg, MAX_PATH ) == 0 ) {
        MessageBox( 0, "GetModuleFileName failed", 0, 0 );
        return FALSE;
      }
      cp = Strrchr( DbgMsg, '.' );
      if( cp != NULL ) *cp = '\0';
      lstrcat( DbgMsg, ".smlog" );
      LogH = CreateFile( DbgMsg, GENERIC_READ | GENERIC_WRITE,
                     0, NULL, OPEN_ALWAYS, 0, NULL );
      if( LogH == INVALID_HANDLE_VALUE ) {
        MessageBox( 0, "CreateFile failed", 0, 0 );
        LogH = NULL;
        return FALSE;
      }
      SetFilePointer( LogH, 0, NULL, FILE_END );
      wsprintf( DbgMsg, "\r\n\r\n***************** log started ************************\r\n\r\n" );
      DbgOut();
      return TRUE;
    }

  static void DbgDestroyOutput()
    {
      if( --DbgUsage == 0 ) { CloseHandle( LogH ); LogH = NULL; }
    }

  static void DbgOut( char* p, ... )
    {
      va_list  n;
      char     b[ 16384 ];
      DWORD    s;

      va_start( n, p );
      VSysLog( p, n );
      wvsprintf( b, p, n );
      lstrcat( b, "\r\n" );
      if( LogH != NULL )
        WriteFile( LogH, DbgMsg, lstrlen( DbgMsg ), &s, NULL );
      va_end(n);
    }

#endif
